/*
 * Decompiled with CFR 0.152.
 */
package org.qnwebrtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.qnwebrtc.CalledByNative;
import org.qnwebrtc.Logging;
import org.qnwebrtc.ThreadUtils;
import org.qnwebrtc.audio.JavaAudioDeviceModule;
import org.qnwebrtc.audio.WebRtcAudioEffects;
import org.qnwebrtc.audio.WebRtcAudioManager;
import org.qnwebrtc.audio.WebRtcAudioUtils;

class WebRtcAudioRecord {
    private static final String TAG = "WebRtcAudioRecordExternal";
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_SOURCE = 7;
    public static final int DEFAULT_AUDIO_FORMAT = 2;
    private final Context context;
    private final AudioManager audioManager;
    private int audioSource;
    private final int audioFormat;
    private long nativeAudioRecord;
    private final WebRtcAudioEffects effects = new WebRtcAudioEffects();
    @Nullable
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    private volatile boolean microphoneMute;
    private byte[] emptyBytes;
    private boolean mExternalAudioInputEnabled;
    private volatile boolean mExternalCanInput;
    private ByteBuffer mInputByteBuffer;
    private int mSampleRate;
    private int mChannels;
    @Nullable
    private final JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback;
    @Nullable
    private JavaAudioDeviceModule.AudioRecordEventListener mAudioRecordEventListener;
    @Nullable
    private JavaAudioDeviceModule.AudioSourceCallback mAudioSourceCallback;
    @Nullable
    private JavaAudioDeviceModule.AudioSourceCallback mMicrophoneAudioSourceCallback;
    @Nullable
    private final JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback;
    private final boolean isAcousticEchoCancelerSupported;
    private final boolean isNoiseSuppressorSupported;

    /*
     * WARNING - void declaration
     */
    public void setExternalAudioInputEnabled(boolean enabled) {
        void var1_1;
        this.mExternalAudioInputEnabled = var1_1;
    }

    public boolean isExternalAudioInputEnabled() {
        return this.mExternalAudioInputEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void inputExternalAudioFrame(byte[] audioData) {
        WebRtcAudioRecord webRtcAudioRecord = this;
        synchronized (webRtcAudioRecord) {
            void var1_1;
            if (!this.mExternalCanInput) {
                Logging.e(TAG, "WebRtcAudioRecord is not create !");
                return;
            }
            if (this.byteBuffer == null) {
                Logging.e(TAG, "WebRtcAudioRecord is not init !");
                return;
            }
            if (this.mInputByteBuffer == null) {
                this.mInputByteBuffer = ByteBuffer.allocate(audioData.length * 2 * 2);
                Logging.i(TAG, "WebRtcAudioRecord allocate buffer " + audioData.length * 2 * 2);
            }
            int n = this.byteBuffer.capacity();
            this.mInputByteBuffer.put((byte[])var1_1);
            while (this.mInputByteBuffer.position() >= n) {
                int n2 = this.mInputByteBuffer.position() - n;
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                this.mInputByteBuffer.flip();
                byteBuffer.put(this.mInputByteBuffer.array(), this.mInputByteBuffer.arrayOffset(), n);
                this.mInputByteBuffer.clear();
                this.mInputByteBuffer.put(this.mInputByteBuffer.array(), this.mInputByteBuffer.arrayOffset() + n, n2);
                this.byteBuffer.clear();
                this.byteBuffer.put(byteBuffer.array(), 0, n);
                if (this.mMicrophoneAudioSourceCallback != null) {
                    this.mMicrophoneAudioSourceCallback.onAudioSourceAvailable(this.byteBuffer, n, System.nanoTime());
                }
                if (this.mAudioSourceCallback != null) {
                    this.mAudioSourceCallback.onAudioSourceAvailable(this.byteBuffer, n, System.nanoTime());
                }
                WebRtcAudioRecord webRtcAudioRecord2 = this;
                webRtcAudioRecord2.nativeDataIsRecorded(webRtcAudioRecord2.nativeAudioRecord, n);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void setAudioSource(int audioSource) {
        WebRtcAudioRecord webRtcAudioRecord = this;
        synchronized (webRtcAudioRecord) {
            void var1_1;
            if (this.audioSource == audioSource) {
                Logging.d(TAG, "Audio source is already ".concat(String.valueOf(audioSource)));
                return;
            }
            this.audioSource = var1_1;
            if (this.audioRecord == null && this.audioThread == null) {
                Logging.w(TAG, "AudioRecord is not initialized!");
                return;
            }
            if (this.audioThread != null) {
                this.stopRecordingInternal();
                WebRtcAudioRecord webRtcAudioRecord2 = this;
                webRtcAudioRecord2.initRecordingInternal(webRtcAudioRecord2.mSampleRate, this.mChannels);
                this.startRecordingInternal();
            } else {
                this.releaseAudioResources();
                WebRtcAudioRecord webRtcAudioRecord3 = this;
                webRtcAudioRecord3.initRecordingInternal(webRtcAudioRecord3.mSampleRate, this.mChannels);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean setAudioParams(int sampleRate, int channelCount) {
        void var2_2;
        void var1_1;
        if (this.audioRecord != null) {
            Logging.w(TAG, "Can not set audio params after initRecording!");
            return false;
        }
        Logging.d(TAG, "Set audio params: " + sampleRate + ", " + channelCount);
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.nativeSetAudioParams(webRtcAudioRecord.nativeAudioRecord, sampleRate, channelCount, WebRtcAudioManager.getInputBufferSize(this.context, this.audioManager, (int)var1_1, (int)var2_2));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioRecordEventListener(JavaAudioDeviceModule.AudioRecordEventListener listener) {
        void var1_1;
        Logging.d(TAG, "Set audio record event listener: ".concat(String.valueOf(listener)));
        this.mAudioRecordEventListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAudioSourceCallback(JavaAudioDeviceModule.AudioSourceCallback audioSourceCallback) {
        void var1_1;
        Logging.d(TAG, "Set audio source callback: ".concat(String.valueOf(audioSourceCallback)));
        this.mAudioSourceCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMicrophoneAudioSourceCallback(JavaAudioDeviceModule.AudioSourceCallback microphoneAudioSourceCallback) {
        void var1_1;
        Logging.d(TAG, "Set microphone audio source callback: ".concat(String.valueOf(microphoneAudioSourceCallback)));
        this.mMicrophoneAudioSourceCallback = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    WebRtcAudioRecord(Context context, AudioManager audioManager) {
        this((Context)var1_1, (AudioManager)var2_2, 7, 2, null, null, WebRtcAudioEffects.isAcousticEchoCancelerSupported(), WebRtcAudioEffects.isNoiseSuppressorSupported());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public WebRtcAudioRecord(Context context, AudioManager audioManager, int audioSource, int audioFormat, @Nullable JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback, @Nullable JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback, boolean isAcousticEchoCancelerSupported, boolean isNoiseSuppressorSupported) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (isAcousticEchoCancelerSupported && !WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            throw new IllegalArgumentException("HW AEC not supported");
        }
        if (isNoiseSuppressorSupported && !WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            throw new IllegalArgumentException("HW NS not supported");
        }
        this.context = var1_1;
        this.audioManager = var2_2;
        this.audioSource = var3_3;
        this.audioFormat = audioFormat;
        this.errorCallback = errorCallback;
        this.audioSamplesReadyCallback = audioSamplesReadyCallback;
        this.isAcousticEchoCancelerSupported = isAcousticEchoCancelerSupported;
        this.isNoiseSuppressorSupported = isNoiseSuppressorSupported;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    public void setNativeAudioRecord(long nativeAudioRecord) {
        void var1_1;
        this.nativeAudioRecord = var1_1;
    }

    @CalledByNative
    boolean isAcousticEchoCancelerSupported() {
        return this.isAcousticEchoCancelerSupported;
    }

    @CalledByNative
    boolean isNoiseSuppressorSupported() {
        return this.isNoiseSuppressorSupported;
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    private boolean enableBuiltInAEC(boolean enable) {
        void var1_1;
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ")");
        return this.effects.setAEC((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @CalledByNative
    private boolean enableBuiltInNS(boolean enable) {
        void var1_1;
        Logging.d(TAG, "enableBuiltInNS(" + enable + ")");
        return this.effects.setNS((boolean)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @CalledByNative
    private int initRecording(int sampleRate, int channels) {
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int n = channels * WebRtcAudioRecord.getBytesPerSample(this.audioFormat);
        int n2 = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(n * n2);
        if (!this.byteBuffer.hasArray()) {
            this.reportWebRtcAudioRecordInitError("ByteBuffer does not have backing array.");
            return -1;
        }
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.nativeCacheDirectBufferAddress(webRtcAudioRecord.nativeAudioRecord, this.byteBuffer);
        if (this.mExternalAudioInputEnabled) {
            return n2;
        }
        WebRtcAudioRecord webRtcAudioRecord2 = this;
        synchronized (webRtcAudioRecord2) {
            void var2_3;
            void var1_1;
            if (!this.initRecordingInternal((int)var1_1, (int)var2_3)) {
                return -1;
            }
        }
        this.effects.enable(this.audioRecord.getAudioSessionId());
        if (this.mAudioRecordEventListener != null) {
            this.mAudioRecordEventListener.onWebRtcAudioRecordInitDone();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        WebRtcAudioRecord webRtcAudioRecord = this;
        synchronized (webRtcAudioRecord) {
            if (this.mExternalAudioInputEnabled) {
                this.mExternalCanInput = true;
                return true;
            }
            return this.startRecordingInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord webRtcAudioRecord = this;
        synchronized (webRtcAudioRecord) {
            if (this.mExternalAudioInputEnabled) {
                this.mExternalCanInput = false;
                return true;
            }
            this.stopRecordingInternal();
        }
        this.effects.release();
        if (this.mAudioRecordEventListener != null) {
            this.mAudioRecordEventListener.onWebRtcAudioRecordReleased();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean initRecordingInternal(int sampleRate, int channels) {
        void var2_3;
        void var1_1;
        Logging.d(TAG, "initRecordingInternal: " + sampleRate + " " + channels);
        int n = this.channelCountToConfiguration(channels);
        int n2 = AudioRecord.getMinBufferSize((int)sampleRate, (int)n, (int)this.audioFormat);
        if (n2 == -1 || n2 == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: ".concat(String.valueOf(n2)));
            return false;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: ".concat(String.valueOf(n2)));
        n2 = Math.max(2 * n2, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: ".concat(String.valueOf(n2)));
        try {
            this.audioRecord = new AudioRecord(this.audioSource, sampleRate, n, this.audioFormat, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + illegalArgumentException.getMessage());
            this.releaseAudioResources();
            return false;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            this.releaseAudioResources();
            return false;
        }
        this.mSampleRate = var1_1;
        this.mChannels = var2_3;
        this.logMainParameters();
        this.logMainParametersExtended();
        return true;
    }

    public boolean startRecordingInternal() {
        Logging.d(TAG, "startRecordingInternal");
        if (this.audioRecord == null) {
            Logging.w(TAG, "AudioRecord is not initialized");
            return false;
        }
        if (this.audioThread != null || this.audioRecord.getRecordingState() == 3) {
            Logging.w(TAG, "AudioRecord is already started");
            return true;
        }
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    public void stopRecordingInternal() {
        this.stopRecordingInternal(true);
    }

    /*
     * WARNING - void declaration
     */
    public void stopRecordingInternal(boolean releaseAudioResources) {
        void var1_1;
        Logging.d(TAG, "stopRecordingInternal");
        if (this.audioThread == null) {
            Logging.w(TAG, "AudioRecord is already stopped");
            return;
        }
        this.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        }
        this.audioThread = null;
        if (var1_1 != false) {
            this.releaseAudioResources();
        }
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate() + ", audio source: " + this.audioRecord.getAudioSource());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        if (channels == 1) {
            return 16;
        }
        return 12;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeDataIsRecorded(long var1, int var3);

    private native void nativeSetAudioParams(long var1, int var3, int var4, int var5);

    /*
     * WARNING - void declaration
     */
    public void setMicrophoneMute(boolean mute) {
        void var1_1;
        Logging.w(TAG, "setMicrophoneMute(" + mute + ")");
        this.microphoneMute = var1_1;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        Logging.e(TAG, "Init recording error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            void var1_1;
            this.errorCallback.onWebRtcAudioRecordInitError((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            void var2_2;
            void var1_1;
            this.errorCallback.onWebRtcAudioRecordStartError((JavaAudioDeviceModule.AudioRecordStartErrorCode)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reportWebRtcAudioRecordError(String errorMessage) {
        Logging.e(TAG, "Run-time recording error: ".concat(String.valueOf(errorMessage)));
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            void var1_1;
            this.errorCallback.onWebRtcAudioRecordError((String)var1_1);
        }
    }

    private static int getBytesPerSample(int audioFormat) {
        int n;
        switch (audioFormat) {
            case 3: {
                return 1;
            }
            case 1: 
            case 2: 
            case 13: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Bad audio format ".concat(String.valueOf(n)));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(WebRtcAudioRecord x0, long x1, int x2) {
        void var3_2;
        void var1_1;
        x0.nativeDataIsRecorded((long)var1_1, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(WebRtcAudioRecord x0, String x1) {
        void var1_1;
        x0.reportWebRtcAudioRecordError((String)var1_1);
    }

    class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        /*
         * WARNING - void declaration
         */
        public AudioRecordThread(String name) {
            void var2_2;
            super((String)var2_2);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            System.nanoTime();
            while (this.keepAlive) {
                Object object;
                int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (WebRtcAudioRecord.this.microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    if (WebRtcAudioRecord.this.mMicrophoneAudioSourceCallback != null) {
                        WebRtcAudioRecord.this.mMicrophoneAudioSourceCallback.onAudioSourceAvailable(WebRtcAudioRecord.this.byteBuffer, n, System.nanoTime());
                    }
                    if (WebRtcAudioRecord.this.mAudioSourceCallback != null) {
                        WebRtcAudioRecord.this.mAudioSourceCallback.onAudioSourceAvailable(WebRtcAudioRecord.this.byteBuffer, n, System.nanoTime());
                    }
                    if (this.keepAlive) {
                        WebRtcAudioRecord.access$800(WebRtcAudioRecord.this, WebRtcAudioRecord.this.nativeAudioRecord, n);
                    }
                    if (WebRtcAudioRecord.this.audioSamplesReadyCallback == null) continue;
                    object = Arrays.copyOfRange(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.arrayOffset(), WebRtcAudioRecord.this.byteBuffer.capacity() + WebRtcAudioRecord.this.byteBuffer.arrayOffset());
                    WebRtcAudioRecord.this.audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(WebRtcAudioRecord.this.audioRecord.getAudioFormat(), WebRtcAudioRecord.this.audioRecord.getChannelCount(), WebRtcAudioRecord.this.audioRecord.getSampleRate(), (byte[])object));
                    continue;
                }
                object = "AudioRecord.read failed: ".concat(String.valueOf(n));
                Logging.e(WebRtcAudioRecord.TAG, (String)object);
                if (n != -3) continue;
                this.keepAlive = false;
                WebRtcAudioRecord.access$1000(WebRtcAudioRecord.this, (String)object);
            }
            try {
                if (WebRtcAudioRecord.this.audioRecord != null) {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
                return;
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + illegalStateException.getMessage());
                return;
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }
}

